<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class People extends Model 
{

    protected $table = 'people';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('flat_id', 'type', 'name', 'surname', 'email', 'phone', 'is_resident');

    public function flat()
    {
        return $this->belongsTo('App\Models\Flat', 'id', 'flat_id');
    }

}